-- Author  : John D P Purba
-- Purpose : Fungsi Rounding

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY Rounding IS
	PORT(clock_i	   : IN std_logic;

  		 data_i        : IN bit128;		-- PlainText
		 round_kunci_i : IN tipe_kunci;	-- Kunci	  
		 mux_sel_i     : IN std_logic;  -- Sinyal selektor multiplexer
		 mix_sel_i     : IN std_logic;	-- Sinyal aktifasi blok MixColumn
		 add_sel_i     : IN std_logic;	-- Sinyal aktifasi blok AddRoundKey
		 data_o        : OUT bit128		-- CipherText
	);
END Rounding;

ARCHITECTURE Struktur OF Rounding IS

COMPONENT Mux21 IS
	PORT(sel_i   : IN std_logic;
	     din_i 	 : IN bit128;
		 tmp_i 	 : IN tipe_state;
		 tmp_o   : OUT tipe_state
	);
END COMPONENT;

COMPONENT AddRoundKey IS
	PORT(kunci_i  : IN tipe_kunci;
		 state_i  : IN tipe_state;
		 sel_i    : IN std_logic;
		 state_o  : OUT tipe_state;
		 data_o   : OUT bit128
	);
END COMPONENT;


COMPONENT ByteSub IS
	PORT(clock_i : in std_logic;
		 byte_i  : IN tipe_state;
		 byte_o  : OUT tipe_state
	);
END COMPONENT;

COMPONENT ShiftRow IS
	PORT(shift_i : IN tipe_state;
	     shift_o : OUT tipe_state
	);	
END COMPONENT;

COMPONENT MixColumn IS
	PORT(mix_i : IN tipe_state;
		 sel_i : IN std_logic;
		 mix_o : OUT tipe_state
	);
END COMPONENT;

SIGNAL sig_temp	      : tipe_state;
SIGNAL sig_mux_out    : tipe_state;
SIGNAL sig_add_out    : tipe_state;
SIGNAL sig_buff_out   : tipe_state;
SIGNAL sig_byte_out   : tipe_state;
SIGNAL sig_shift_out  : tipe_state;


BEGIN

Mux	  : Mux21 PORT MAP(mux_sel_i, data_i, sig_temp, sig_mux_out);

Add	  : AddRoundKey PORT MAP(round_kunci_i, sig_mux_out, add_sel_i, sig_add_out, data_o);

Byte  : ByteSub PORT MAP(clock_i, sig_add_out, sig_byte_out);

Shift : ShiftRow PORT MAP(sig_byte_out, sig_shift_out);

Mix	  : MixColumn PORT MAP(sig_shift_out, mix_sel_i, sig_temp);

END Struktur;



























